# Read the data with comma as delimiter
myData <- read.table(file = "sun_led.csv", header = TRUE, sep = ",")

# Check column names to confirm successful reading
print(names(myData))

# Proceed with the Kruskal-Wallis test
result <- kruskal.test(r_value ~ group, data = myData)
print(result)

if (!requireNamespace("ggplot2", quietly = TRUE)) {
  install.packages("ggplot2")
}

# Load the ggplot2 package

# Perform Kruskal-Wallis test
kruskal_test <- kruskal.test(r_value ~ group, data = myData)
p_value <- kruskal_test$p.value

library(ggplot2)
p <- ggplot(myData, aes(group, r_value)) +
  geom_violin(aes(fill = group), color = "black", alpha = 0.7) +  # Different colors for violins
  geom_boxplot(width = 0.2, outlier.shape = NA) +
  geom_dotplot(binaxis = 'y', stackdir = 'center', dotsize = 1) +
  stat_summary(fun = median, geom = "crossbar", width = 0.3, color = "red", size = 1) +  # Red, bold median line
  stat_summary(fun = median, geom = "text", aes(label = round(..y.., 2)), vjust = -0.2, color = "red", size = 2) +  # Display median values
  scale_fill_manual(values = c("skyblue", "salmon", "lightgreen","red", "yellow", "blue","grey","pink", "purple","darkgreen"   )) +  # Customize colors as desired
  theme_minimal(base_size = 20) +
  theme(
    panel.grid = element_line(color = "gray90"),
    legend.position = "none",
    plot.background = element_rect(fill = "white", color = NA)
  )+
  stat_summary(
    fun = median,
    geom = "text",
    aes(label = round(..y.., 2)),
    position = position_nudge(x = 0.4),  # Move the text to the side of the violin
    color = "red",
    size = 8
  ) +
  annotate("text", x = 1.5, y = max(myData$r_value) * 1.1, 
           label = paste("Kruskal-Wallis p =", round(p_value, 4)), 
           color = "blue", size = 7, hjust = 0.5)  # Place p-value at the top center
p